
#include <errno.h> 
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <termios.h>       	
#include <time.h>  
#include <sys/ioctl.h>  



#define SERIAL_PORT "/dev/ttyUSB0"
#define SERIAL_SPEED B115200


#define TRUE        1
#define FALSE       0
//-------------------------------------------------------------------------------------------

#define Small	 0
#define Medium	 1
#define Large	 2

#define Green       0
#define Red         1
#define Yellow      2
#define Orange      3
#define OrangeLight 4


#define END         0xC0
#define ESC         0xDB
#define ESC_END     0xDC
#define ESC_ESC     0xDD


#define X_BLOCK     621
#define Y_BLOCK     60
#define LAQU        22
#define PASSO       200

#define ECAT_TIME   100
#define ERROR_TIME  3000

Display *dpy;
Window win,win_returned;
Pixmap double_buffer;
XWindowAttributes wa;


XEvent evt;
GC gc;

XColor xcGreen, xcYellow, xcRed, xcOrange, xcBlack;

char cGreen[] 		= "#00FF00";			// definizione colori		
char cYellow[] 	    = "#FFFF00";							
char cRed[] 		= "#FF0000";
char cOrange[] 	    = "#FF9933";
char cOrangeLight[] = "#FFCC33";


int pBlack, pWhite, pGreen, pYellow, pRed, pOrange, pOrangeLight;   
XColor xcGreen, xcYellow, xcRed, xcOrange, xcOrangeLight;
Colormap colormap;
XFontStruct *FsSmall, *FsMedium, *FsLarge;

int win_x, win_y,root_x,root_y;
unsigned int mask_returned;

char FontLarge[] = "rk24";
char FontSmall[] = "R16";

char *programname = "Test EasyCAT USB";


unsigned char InBuff[32];
unsigned char OutBuff[34];

unsigned char SlipTxBuff[128];	
unsigned char SlipRxBuff[128];
unsigned long EcatTime, PrevEcatTime, ErrorTime;

unsigned char Error = False;

int fd;
struct termios options;  

const char NoSetOut[35] = "IT IS NOT POSSIBLE TO SET OUTPUTS !";
const char Run[35]      = "                  EtherCAT  RUNNING";
const char Dog[35]      = "             WATCH DOG !           ";


//--------------------------------------------------------------------------------------------

void DrawBaseGrid (void);
void DrawSquare(int x, int y, int Color, int Lato);
void ClearSquare(int x, int y, int Lato);
void DrawByteInSquare(unsigned char Data, int x, int y, int Color);
unsigned char FindByte(int Y_Click, int Y_Origine);
unsigned char FindBit(int X_Click, int X_Origine);
void DrawInput(void);
void DrawOutput(void);
void SetColor(int Color);
void QueryMouseClick(void);
unsigned char UnWrapSlipFrame(unsigned char *BuffIn, unsigned char *BuffOut);
void DrawAnimation(int x, int y);
void WatchDog (void); 


unsigned long Millis(void);

void PrintValue (int x, int y, int Value, int Color, int Size);
void PrintMessage(int x_mess, int y_mess, const char *ptr, int Color);

void TxSlipFrame(void);


unsigned char AnimState;

int ContaDog_1 = 0;
int ContaDog_2 = 0;

int PrimoGiro = 0;

int ErrorLoop_30 = 0; 
int ErrorLoop_31 = 0; 

//--------------------------------------------------------------------------------------------


int main( int argc, char **argv ) 
{
	int i;
	int XSsi;

    int NumChar;

    int RTS_flag;
    RTS_flag = TIOCM_RTS;


	dpy = XOpenDisplay(NULL);							    // connettiti al display di default
	if (!dpy)
	{
		printf("errore di connessione al display");
		exit(1);
	}

	pBlack = BlackPixel( dpy, DefaultScreen(dpy));
	pWhite = WhitePixel( dpy, DefaultScreen(dpy));

	colormap = DefaultColormap( dpy, 0 );

	XParseColor( dpy, colormap, cGreen, &xcGreen );
	XAllocColor( dpy, colormap, &xcGreen);

	XParseColor( dpy, colormap, cYellow, &xcYellow );
	XAllocColor( dpy, colormap, &xcYellow );

	XParseColor( dpy, colormap, cRed, &xcRed );
	XAllocColor( dpy, colormap, &xcRed );

	XParseColor( dpy, colormap, cOrange, &xcOrange);
	XAllocColor( dpy, colormap, &xcOrange );

	XParseColor( dpy, colormap, cOrangeLight, &xcOrangeLight);
	XAllocColor( dpy, colormap, &xcOrangeLight );

													
	win = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), 0, 0, 800, 550, 0, pBlack, pBlack ); // crea una finestra

    XGetWindowAttributes(dpy, win, &wa);

													        // seleziona gli eventi che ci interessa ricevere			
	XSelectInput( dpy, win, StructureNotifyMask | ButtonPressMask | ExposureMask);

	XMapWindow( dpy, win );								    // rendi la finestra visibile sul display

	XmbSetWMProperties( dpy, win, 						    // aggiungi le proprieta' alla finestra
					    "Test EasyCAT USB",
					    programname,
					    argv, 
					    argc, 
					    NULL,					
					    NULL, 
					    NULL 
				      );


	gc = XCreateGC( dpy, win, 0, NULL );					// definisci il graphic context
	
	XSetForeground( dpy, gc, pWhite );

	FsSmall = XLoadQueryFont( dpy, FontSmall );			    // carica i font
	if( !FsSmall )                                          //    
	{                                                       //        
		perror("Font Small load failed");                   //

		exit(1);                                            //
	}                                                       //

	FsLarge = XLoadQueryFont( dpy, FontLarge );	            //
	if( !FsLarge )                                          //    
	{                                                       //        
		perror("Font Large load failed");                   //
		exit(1);                                            //
	}                                                       //

	XSetFont( dpy, gc, FsSmall->fid );					    // setta il font piccolo


	while(1)											    // aspetta MapNotify e fa flush
	{												
		XNextEvent( dpy, &evt );
		if( evt.type == MapNotify ) 
			break;
	}


 	fd = open(SERIAL_PORT, O_RDWR | O_NOCTTY);
   	if (fd == -1)
	{
		printf("Cannot open serial port SERIATxSlipFrameL_PORT\n\r");
 		return;
	}

	else
	{									
   		tcgetattr(fd, &options);							// leggi le opzioni attuali nella struttura

      	if(cfsetispeed(&options, SERIAL_SPEED)==-1)			// setta baud rate ricezione
		{			     							        //			
			printf("\n\rError setting rx baudrate ");       //	
       		return;									        //		
      	}											        //

      	if(cfsetospeed(&options, SERIAL_SPEED)==-1)			// setta baud rate in trasmissione
		{											        //		
			printf("\n\rError setting tx baudrate ");		//
       		return;									        //
      	}											        //

		options.c_cc[VMIN] = 0;      						// 
		options.c_cc[VTIME] = 1; 						    // time out di ricezione 100mS				

		options.c_cflag |= (CLOCAL | CREAD);				// enable the receiver and set local mode

		options.c_cflag &= ~PARENB;					     	// no parita'	
		options.c_cflag &= ~CSTOPB;						    // 1 bit di stop
		options.c_cflag &= ~CSIZE;						    // 8 bit di dati 	
		options.c_cflag |= CS8;							    //		"

		options.c_iflag &= ~(IXON | IXOFF | IXANY);			// disable software flow control
		options.c_iflag &= ~( INLCR | IGNCR | ICRNL);	    // non trasformare CR e LF	
	
		options.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);	// receive raw mode no echo
		options.c_oflag &= ~OPOST;						    // transmit raw mode	

		tcsetattr(fd, TCSANOW, &options);					// setta le nuove opzioni


 //       ioctl(fd,TIOCMBIC,&RTS_flag);                       // reset RTS pin

		printf("Opened serial port %s\n\r",SERIAL_PORT);  
	} 




//***********************************************************************************************************
//                                                                                                          *
//                              main loop                                                                   *
//                                                                                                          *
//***********************************************************************************************************


    while (1)

	{ 	
		if (XCheckWindowEvent(dpy, win,  ButtonPressMask, &evt))        // controlla se si e' clicckato il mouse 
		{                                                               //
			QueryMouseClick();                                          //                  
        }                                                               //  

        if (XCheckWindowEvent(dpy, win, ExposureMask, &evt))            // gestisci il redraw della finestra
        {                                                               //
            if (evt.xexpose.count==0)                                   //
            {                                                           //
            //  printf("REDRAW\n\r");                                   // 
                DrawBaseGrid ();                                        //
                DrawInput();                                            //       
                DrawOutput();                                           //
		        while (XCheckWindowEvent(dpy, win, ExposureMask, &evt)) //
                {}                                                      //        
            }                                                           //
        }                                                               //


        EcatTime = Millis();                                            //------ gestione EtherCAT --------           
        if (EcatTime - PrevEcatTime > ECAT_TIME)                        //
        {                                                               //
            PrevEcatTime = EcatTime;                                    //
            TxSlipFrame();                                              //

                                                                        //
            NumChar = read(fd,SlipRxBuff,128);                          // lettura dati da linea seriale
            if (NumChar < 36)                                           // se non si sono ricevuti almeno        
            {                                                           // 36 caratteri il frame non e' valido
                WatchDog();        
                ContaDog_1++;
                PrimoGiro = 0;
                printf("\n\r Errore 1 %d", ContaDog_1);	                               
            }

            else                                                        // perche' il frame sia valido la funzione di unwrap
            {                                                           // deve restituire "True" ed il byte di stato
                                                                        // deve segnalare "operational" (0x08)        
                if ((UnWrapSlipFrame(SlipRxBuff, OutBuff) == True) && (OutBuff[32] == 0x08))
                {
                    PrintMessage(40, 450, Run, Green);                                          
                    DrawAnimation(550,477);

                    if (PrimoGiro == 0)
                    {
                        PrimoGiro = 1;
                        printf("\n\r Versione %d \n\r", OutBuff[33]);	
                    }
                }
                else
                {
                    WatchDog();
                    ContaDog_2++;
                    PrimoGiro = 0;
                    printf("\n\r Errore 2 %d", ContaDog_2);	
                }    
            }   
 

            if (Error == True)                                          // gestione errore se si e' tentato
            {                                                           // di cambiare un output    
                if (Millis() - ErrorTime > ERROR_TIME)                  //
                {                                                       //
                    XClearArea(dpy, win, 160, 200, 500 , 60, False);    //
                    DrawBaseGrid ();                                    //      
                    DrawInput();                                        //                
                    DrawOutput();                                       //
                    Error = False;                                      //
                }
            }

            else                                                        // situazione normale
            {                                                           //
                DrawOutput();                                           // visualizza gli output
                DrawInput();                                            // visualizza gli input
            }                                                           //    

            InBuff[30] -= 1;                                            // generazione di due denti di sega            
            InBuff[31] += 1;                                            // negli ultimi byte per test
        }
	}
}


//***********************************************************************************************************
//                                                                                                          *
//                              funzioni                                                                    *
//                                                                                                          *
//***********************************************************************************************************


unsigned long Millis(void)
{
    struct timespec ts;
    clock_gettime(CLOCK_MONOTONIC, &ts );
    return ( ts.tv_sec * 1000 + ts.tv_nsec / 1000000L );
}



void WatchDog (void)                                        // gestione watchdog

{
    int i;

    PrintMessage(160, 450, Dog, Red);                       // stampa il messaggi di watchdog

    for (i=0; i<32; i++)                                    // azzera il buffer degli output
    {                                                       //    
        OutBuff[i] = 0x00;                                  //
    }                                                       //
}



//******************************************************************************************************
//          gestione mouse
//*******************************************************************************************************


//-------	controlla il click del mouse -----------------------------------------------------------------

void QueryMouseClick(void)

{
    unsigned char Byte;
    unsigned char BitMask;

	if (evt.type == ButtonPress)
	{
		XQueryPointer(dpy,win,&win_returned,&win_returned,&root_x,&root_y,&win_x,&win_y,&mask_returned);

		printf("\n\r%d  %d",win_x,win_y);				    // stampa le coordinate del click del mouse
                                                            // per debug
		if (  (win_x > (X_BLOCK-(PASSO*3))) 
           && (win_x < (X_BLOCK-(PASSO*3)+(LAQU*8)))
           && (win_y >  Y_BLOCK)  
           && (win_y < (Y_BLOCK+(LAQU*16)))  )

        {
            Byte = FindByte(win_y, Y_BLOCK);
            BitMask = FindBit(win_x,(X_BLOCK-(PASSO*3)));           
            InBuff[Byte] ^= BitMask;
        }

		if (  (win_x > (X_BLOCK-(PASSO*2))) 
           && (win_x < (X_BLOCK-(PASSO*2)+(LAQU*8)))
           && (win_y >  Y_BLOCK)  
           && (win_y < (Y_BLOCK+(LAQU*16)))  )

        {
            Byte = FindByte(win_y, Y_BLOCK);
            BitMask = FindBit(win_x,(X_BLOCK-(PASSO*2)));           
            InBuff[Byte+16] ^= BitMask;
        }

		if  (
                (  (win_x > (X_BLOCK-(PASSO*1))) 
                && (win_x < (X_BLOCK-(PASSO*1)+(LAQU*8)))
                && (win_y >  Y_BLOCK)  
                && (win_y < (Y_BLOCK+(LAQU*16)))  )
                ||
                (  (win_x > (X_BLOCK-(PASSO*0))) 
                && (win_x < (X_BLOCK-(PASSO*0)+(LAQU*8)))
                && (win_y >  Y_BLOCK)  
                && (win_y < (Y_BLOCK+(LAQU*16)))  )
            )
        {
            PrintMessage(160, 200, NoSetOut, Red);
            Error = True;
            ErrorTime = Millis();
        }
    }
}


//--- individua il byte su cui si e' cliccato ---------------------------------------------
                                                        //
                                                        // Y_Click = Y del mouse
                                                        // Y_Origine = Y dell'origine del blocco 
                                                        //             su cui si e' cliccato
                                                        //
                                                        // return Byte = byte su cui si e' cliccato
unsigned char FindByte(int Y_Click, int Y_Origine)      //               da 0 a 15
{
    unsigned char Byte;

    Byte = (Y_Click - Y_Origine) / LAQU;
    return Byte;
}


//--- individua il bit su cui si e' cliccato ---------------------------------------------
                                                        //
                                                        // X_ClickAnimState = X del mouse
                                                        // X_Origine = X dell'origine del blocco 
                                                        //             su cui si e' cliccato
                                                        //                                                        
unsigned char FindBit(int X_Click, int X_Origine)       // return BitMask = byte con a uno il bit su
{                                                       //                  cui si e' cliccato
    unsigned char BitMask;
    unsigned char Bit;

    Bit = (X_Click - X_Origine) / LAQU;
    BitMask =  0x80 >> Bit;
    return BitMask;
} 



//******************************************************************************************************
//          gestione grafica
//*******************************************************************************************************


//---- stampa la quadrettatura di base ----------------------------------------------------

void DrawBaseGrid (void)

{
    int i;
    int k;
    int Conta;


    for (k=0; k<4; k++)
    {
	    XSetLineAttributes(dpy, gc, 1, LineSolid, CapButt, JoinMiter);
        XSetForeground( dpy, gc, xcOrange.pixel );
	    XDrawLine(dpy, win, gc, X_BLOCK-(PASSO*k), Y_BLOCK, X_BLOCK-(PASSO*k)+(8*LAQU),Y_BLOCK);

        Conta = k;
        Conta &= 0x01;
        Conta ^= 0x01;
        Conta = Conta << 4; 

	    for (i=0; i<16; i++)
	    {
            XSetForeground( dpy, gc, xcOrange.pixel );
		    XDrawLine(dpy, win, gc, X_BLOCK-(PASSO*k), ((i+1)*LAQU)+Y_BLOCK, X_BLOCK-(PASSO*k)+(8*LAQU), ((i+1)*LAQU)+Y_BLOCK );

            PrintValue (X_BLOCK-(PASSO*k) -60, ((i+1)*LAQU)+Y_BLOCK-(LAQU/4), Conta, Green, Small);
            Conta++;
	    }

	    for (i=0; i<9; i++)
	    {
            XSetForeground( dpy, gc, xcOrange.pixel );
		    XDrawLine(dpy, win, gc, (i*LAQU)+X_BLOCK-(PASSO*k), Y_BLOCK, (i*LAQU)+X_BLOCK-(PASSO*k), Y_BLOCK+(16*LAQU));
	    }
    }

    XSetFont( dpy, gc, FsSmall->fid );

    XSetForeground( dpy, gc, xcYellow.pixel );
	XDrawString( dpy, win, gc, X_BLOCK-(PASSO*3)+7, Y_BLOCK+(17*LAQU), "Inputs from  0 to 15", 20);  
	XDrawString( dpy, win, gc, X_BLOCK-(PASSO*2)+7, Y_BLOCK+(17*LAQU), "Inputs from 15 to 31", 20); 

    XSetForeground( dpy, gc, xcRed.pixel );
	XDrawString( dpy, win, gc, X_BLOCK-(PASSO*1)+7, Y_BLOCK+(17*LAQU), "Outputs from  0 to 15", 21); 
	XDrawString( dpy, win, gc, X_BLOCK-(PASSO*0)+7, Y_BLOCK+(17*LAQU), "Outputs from 16 to 31", 21); 
}


//---- disegna il contenuto del buffer di input usando i quadretti -----------------------

void DrawInput(void)
{
    int i;

    for (i=0; i<16; i++)
    {
        DrawByteInSquare(InBuff[i], X_BLOCK-(PASSO*3), Y_BLOCK+(LAQU*i), Yellow );
    }
    for (i=0; i<16; i++)
    {
        DrawByteInSquare(InBuff[i+16], X_BLOCK-(PASSO*2), Y_BLOCK+(LAQU*i), Yellow );
    }
}


//---- disegna il contenuto del buffer di output usando i quadretti -----------------------

void DrawOutput(void)
{
    int i;

    for (i=0; i<16; i++)
    {
        DrawByteInSquare(OutBuff[i], X_BLOCK-(PASSO*1), Y_BLOCK+(LAQU*i), Red);
    }
    for (i=0; i<16; i++)
    {
        DrawByteInSquare(OutBuff[i+16], X_BLOCK-(PASSO*0), Y_BLOCK+(LAQU*i), Red);
    }
}


//----- disegna un byte usando i quadretti ---------------------------------------------------
                                                        //
                                                        // Data = byte da disegnare
                                                        // x = x del quadretto
                                                        // y = Y del quadretto
                                                        // Color = colore (Red o Yellow)
                                                   
void DrawByteInSquare(unsigned char Data, int x, int y, int Color)
{
    int i;
    unsigned char Mask = 0x80;

    for (i=0; i<8; i++)
    {
        if ((Data & Mask) != 0)
        {
            DrawSquare (x+(LAQU*i), y, Color, LAQU-1);    
        }
        else
        {
            ClearSquare (x+(LAQU*i), y, LAQU-1);     
        }
        
        Mask = Mask >> 1;
    }
}


//--- disegna un quadretto ------------------------------------------------------------
                                                        //
                                                        // x = x del quadretto
                                                        // y = Y del quadretto
                                                        // Color = colore (Red o Yellow)
void DrawSquare(int x, int y, int Color, int Lato)
{
    SetColor(Color);

	XSetLineAttributes(dpy, gc, 1, LineSolid, CapButt, JoinMiter);
	XFillRectangle(dpy, win, gc, x+1, y+1, Lato, Lato);
}


void ClearSquare(int x, int y, int Lato)
{
    XClearArea(dpy, win, x+1, y+1, Lato , Lato, False); 
}


//-------	visualizza un numero -----------------------------------------------------------------

void PrintValue (int x, int y, int Value, int Color, int Size)

{

char AsciiString[16];
int i;
int NumChar;

    SetColor(Color);    

    sprintf(AsciiString,"%d",Value); 
    NumChar = strlen(AsciiString);

    if (Size == Large)
    {
        XSetFont( dpy, gc, FsLarge->fid );

        XClearArea(dpy, win, x, y-25, (20*6) , 25, False);

        x = (x + (20 * (6 - NumChar)));

        for (i = 0;  i < NumChar; i++)
        {
            XDrawString( dpy, win, gc, x + (i*20), y, &AsciiString[i], 1);
        }
    }

    else if (Size == Small)
    {
        XSetFont( dpy, gc, FsSmall->fid );

    	XClearArea(dpy, win, x, y-15, (12*6) , 18, False);

        x = (x + (10 * (6 - NumChar)));

        for (i = 0;  i < NumChar; i++)
        {
            XDrawString( dpy, win, gc, x + (i*10), y, &AsciiString[i], 1);
        }
    }
}


//---- visualizza un messaggio --------------------------------------------------------------------

void PrintMessage(int x_mess, int y_mess, const char *ptr, int Color)

{
    SetColor(Color);
    XSetFont( dpy, gc, FsLarge->fid);

    XClearArea(dpy, win, x_mess, y_mess, 500, 60, False); 
    XDrawString( dpy, win, gc, x_mess+40, y_mess+40,ptr , 35); 
}


//---- setta un colore ---------------------------------------------------------------

void SetColor(int Color)
{
    switch (Color)
    {
        case Red:
	    XSetForeground( dpy, gc, xcRed.pixel );
        break;

        case Green:
	    XSetForeground( dpy, gc, xcGreen.pixel );
        break;

        case Orange:
	    XSetForeground( dpy, gc, xcOrange.pixel );
        break;

        case OrangeLight:
	    XSetForeground( dpy, gc, xcOrangeLight.pixel );
        break;

        case Yellow:
	    XSetForeground( dpy, gc, xcYellow.pixel );
        break;
    }
}


//---- disegna l'animazione -------------------------------------------------------------

void DrawAnimation(int x, int y)

{
    #define ANIM_RADIUS 1
    #define ANIM_LATO 2
    #define ANIM_COLOR Green

    switch(AnimState)
    {
        case 0:
        ClearSquare(x-(7*ANIM_RADIUS), y+(3*ANIM_RADIUS), ANIM_LATO);
        DrawSquare(x+(7*ANIM_RADIUS), y+(3*ANIM_RADIUS), ANIM_COLOR, ANIM_LATO);
        break;

        case 1:
        ClearSquare(x-(7*ANIM_RADIUS), y-(3*ANIM_RADIUS), ANIM_LATO);
        DrawSquare(x+(3*ANIM_RADIUS), y+(7*ANIM_RADIUS), ANIM_COLOR, ANIM_LATO);
        break;

        case 2:
        ClearSquare(x-(3*ANIM_RADIUS), y-(7*ANIM_RADIUS), ANIM_LATO);
        DrawSquare(x-(3*ANIM_RADIUS), y+(7*ANIM_RADIUS), ANIM_COLOR, ANIM_LATO);
        break;

        case 3:
        ClearSquare(x+(3*ANIM_RADIUS), y-(7*ANIM_RADIUS), ANIM_LATO);
        DrawSquare(x-(7*ANIM_RADIUS), y+(3*ANIM_RADIUS), ANIM_COLOR, ANIM_LATO);
        break;

        case 4:
        ClearSquare(x+(7*ANIM_RADIUS), y-(3*ANIM_RADIUS), ANIM_LATO);
        DrawSquare(x-(7*ANIM_RADIUS), y-(3*ANIM_RADIUS), ANIM_COLOR, ANIM_LATO);
        break;

        case 5:
        ClearSquare(x+(7*ANIM_RADIUS), y+(3*ANIM_RADIUS), ANIM_LATO);
        DrawSquare(x-(3*ANIM_RADIUS), y-(7*ANIM_RADIUS), ANIM_COLOR, ANIM_LATO);
        break;

        case 6:
        ClearSquare(x+(3*ANIM_RADIUS), y+(7*ANIM_RADIUS), ANIM_LATO);
        DrawSquare(x+(3*ANIM_RADIUS), y-(7*ANIM_RADIUS), ANIM_COLOR, ANIM_LATO);
        break;

        case 7:
        ClearSquare(x-(3*ANIM_RADIUS), y+(7*ANIM_RADIUS), ANIM_LATO);
        DrawSquare(x+(7*ANIM_RADIUS), y-(3*ANIM_RADIUS), ANIM_COLOR, ANIM_LATO);
        break;
    }
    AnimState++;
    AnimState &= 0x07;
}


//******************************************************************************************************
//          gestione comunicazione
//*******************************************************************************************************


//---- Trasmissione di un buffer con l'Uart --------------------------------------------------------------
                                                        //
                                                        // si trasmettono 32 byte incapsulati     
                                                        // in un frame Slip
void TxSlipFrame(void)

{
    int i;
    int j;

    j = 0;  

    SlipTxBuff[j] = END;
    j++;

    for (i=0; i<32; i++)
    {
        switch (InBuff[i])
        {
            case END:
            SlipTxBuff[j] = ESC;           
            j++;    

            SlipTxBuff[j] = ESC_END;
            j++;
            break;

            case ESC:
            SlipTxBuff[j] = ESC;
            j++;
            SlipTxBuff[j] = ESC_ESC;
            j++;
            break;

            default:
            SlipTxBuff[j] = InBuff[i];
            j++;
            break;
        }
    }

    SlipTxBuff[j] = END;
    j++;

	write(fd, SlipTxBuff, j);
}


//---- estrai i dati da un frame Slip --------------------------------------------------
                                                    //
                                                    // il buffer estratto deve
                                                    // essere lungo 34 byte
                                                    // 32 di dati +1 di stato +1 di versione    

unsigned char UnWrapSlipFrame(unsigned char *BuffIn, unsigned char *BuffOut)

{
    int i;
    unsigned char Result;
    unsigned char FrameComplete = False;
    unsigned char PreviousRxChar = 0x00;
    unsigned char RxChar;
    unsigned char Len = 0;


    if(BuffIn[0] != END)                            // verifica che il frame inizi con END
    {                                               //
        Result = False;                             //
        return Result;                              //
    }                                               //

    else                                            //----loop di analisi del buffer di ingresso ----
    {
        for (i=1; i<128; i++)   
        {
            RxChar = BuffIn[i];

            switch(RxChar)                          // analizza il carattere ricevuto
            {
                case ESC:                           //--- e' ESC: si aspetta il carattere successivo ---
                PreviousRxChar = RxChar;            //
                break;                              //
              
                case END:                           //--- e' END: il frame e' finito -------------------                
                if (Len == 34)                      // se si sono ricevuti 34 caratteri il frame e' valido
                    Result = True;                  //
                else                                //
                    Result = False;                 //
                                                    //
                FrameComplete = True;               // in ogni caso esci
                break;                              //
              
                default:                            //--- e' un carattere normale ----------------------
                                                    //    
                if(PreviousRxChar == ESC)           // se il carattere precedente era ESC bisogna
                {                                   // decodificare il carattere ricevuto 
                    PreviousRxChar = RxChar;        //
                                                    //
	                switch(RxChar)                  //    
                    {                               //        
	                    case ESC_END:               // e' un carattere uguale a END 
	                    RxChar = END;               //
	                    break;                      //
                                                    //
	                    case ESC_ESC:               // e' un carattere uguale a ESC
	                    RxChar = ESC;               //    
	                    break;                      //    
	                }                               //
                }                                   //    
                                            
                else                                // si usa il carattere senza modificarlo
                {                                   //
                    PreviousRxChar = RxChar;        //
                }                                   //
                                                                
                BuffOut[Len] = RxChar;              // metti il carattere ricevuto nel buffer                
                Len++;                              // incrementa il numero di caratteri ricevuti
                                                   
                if(Len > 34)                        // se c'e' buffer overflow esci segnalando
                {                                   // frame non valido 
                    Result = False;                 //
                    FrameComplete = True;           //       
                }                                   //    
                break;                              //
            }
                    
            if (FrameComplete == True)              // il frame e' terminato
                break;                              // esci dal loop
        }
    }    
    return Result;
}





 







